<?php

class ControllerPaymentGateline extends Controller {

    function ob_exit($status = null) {
        if ($status) {
            ob_end_flush();
            isset($_REQUEST['debug']) ? exit($status) : exit();
        } else {
            ob_end_clean();
            header("HTTP/1.0 200 OK");
            echo "OK";
            exit();
        }
    }

    function debug_file() {
        header('Content-type: text/plain; charset=utf-8');
        echo file_get_contents(__FILE__);
    }

    function check_im() {
        $iplist = gethostbynamel('gateline.net');
        foreach ($iplist as $ip)
            if (preg_match("/^$ip/", (isset($_SERVER['HTTP_REFERER'])) ? $_SERVER['HTTP_REFERER'] : ''))
                return true;
        return false;
    }

    function from_request($name) {
        return isset($this->request->request[$name]) ? html_entity_decode($this->request->request[$name]) : null;
    }

    public function index() {
        $data['button_confirm'] = $this->language->get('button_confirm');
        $data['button_back'] = $this->language->get('button_back');

        $this->load->model('checkout/order');

        $data['action'] = $this->config->get('gateline_link');
        $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

        $products = '';

        foreach ($this->cart->getProducts() as $product) {
            $products .= $product['quantity'] . ' x ' . $product['name'] . ', ';
        }
        
        $amount = number_format($order_info['total'], 2, '.', '');
        $idShop = $this->config->get('gateline_eshopid');
        $idOrder = $this->session->data['order_id'];
        $desc = "Заказ ".$idOrder;
        $initPass = $this->config->get('gateline_initialization_password');
        
        $message = "amount=".$amount.";description=".$desc.";email=".$order_info['email'].";merchant_order_id=".$idOrder.";site=".$idShop;
        $checksum = hash_hmac('sha1', $message, $initPass);
        
        $data['site'] = $idShop;
        $data['email'] = $order_info['email'];
        $data['amount'] = $amount;
        $data['description'] = $desc;
        $data['merchant_order_id'] = $idOrder;
        $data['checksum'] = $checksum;
        if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/payment/gateline.tpl')) {
            $this->cart->clear();
            return $this->load->view($this->config->get('config_template') . '/template/payment/gateline.tpl', $data);
        } else {
            $this->cart->clear();
            return $this->load->view('default/template/payment/gateline.tpl', $data);
        }
    }

    public function callback() {
        ob_start();

        if (isset($_REQUEST['LMI_PREREQUEST']) && $_REQUEST['LMI_PREREQUEST'] ==1) {
            echo 'YES';
            die();
        }
        if (!isset($_REQUEST['merchant_order_id'])) {
            $this->ob_exit("ERROR: EMPTY REQUEST!\n");
        }

        $merchant_order_id = $this->from_request('merchant_order_id');
        $site = $this->from_request('site');
        $amount = $this->from_request('amount');
        $LMI_MODE = $this->from_request('LMI_MODE');
        $LMI_SYS_INVS_NO = $this->from_request('LMI_SYS_INVS_NO');
        $LMI_SYS_TRANS_NO = $this->from_request('LMI_SYS_TRANS_NO');
        $LMI_SYS_TRANS_DATE = $this->from_request('LMI_SYS_TRANS_DATE');
        $LMI_PAYER_PURSE = $this->from_request('LMI_PAYER_PURSE');
        $LMI_PAYER_WM = $this->from_request('LMI_PAYER_WM');
        $LMI_HASH = $this->from_request('LMI_HASH');
        $LMI_SECRET_KEY = $this->from_request('LMI_SECRET_KEY');

        $shopId = $this->config->get('gateline_eshopid');
        //$shopSecret = $this->config->get('gateline_secret_key');
        $err = FALSE;
 
        $this->load->model('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($merchant_order_id);

        // ORDER ID CHECK
        if (!$order_info) {
            $this->ob_exit("ERROR: ORDER NOT EXISTS!\n");
        }
        $amount = number_format($order_info['total'], 2, '.', '');
        $this->model_checkout_order->addOrderHistory($merchant_order_id, $this->config->get('config_order_status_id'));
        if ($amount != $amount) {
             $err=TRUE;
             $errText="Amount mismatch";
             $this->ob_exit($errText);
        }
        if ($shopId!=$site) {
             $err=TRUE;
             $errText="Shop Id mismatch";
             $this->ob_exit($errText);
        }
        if ($LMI_SECRET_KEY) {
           if($LMI_SECRET_KEY!=$shopSecret) {
               $err = TRUE;
               $errText='secret key mismatch';
               $this->ob_exit($errText);   
            }
        } else {
            $CalcHash = md5($site.$amount.$merchant_order_id.$LMI_MODE.$LMI_SYS_INVS_NO.$LMI_SYS_TRANS_NO.$LMI_SYS_TRANS_DATE.$shopSecret.$LMI_PAYER_PURSE.$LMI_PAYER_WM);
           if($LMI_HASH != strtoupper($CalcHash)) { 
               $err = TRUE;
               $errText='hash mismatch';
               $this->ob_exit($errText);
           }
        }
        if (!$err) {
            $this->model_checkout_order->addOrderHistory($merchant_order_id, $this->config->get('gateline_order_status_id'), 'Gateline', False);
            $this->ob_exit();
            echo 'YES';
            die();
        }
    }
    public function result_payment() {
        $this->load->language('payment/gateline');
        $message = '';
        if (isset($_GET['message'])) {
            $message = $_GET['message'] .'<br>';
        }

        $status = isset($_GET['status']) ? $_GET['status'] : '';

        switch ($status) {
            case 'failed': $message .= $this->language->get('payment_result_failed'); break;
            case 'success' : $message .= $this->language->get('payment_result_success'); break;
            default  : $message .= $this->language->get('payment_result_error'); break;
        }
        $merchant_order_id = $_GET['merchant_order_id'];
        $this->load->model('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($merchant_order_id);

        if (isset($_GET['status']) && isset($_GET['route']) && isset($_GET['message'])) {
            $msg = "";
            if (isset($_GET['code'])) { $msg .= "code=".$_GET['code'].";"; }
            if (isset($_GET['merchant_order_id'])) { $msg .= "merchant_order_id=".$_GET['merchant_order_id'].";"; }
            $msg .= "message=".$_GET['message'].";";
            if (isset($_GET['order_id'])) { $msg .= "order_id=".$_GET['order_id'].";"; }
            $msg .= "route=".$_GET['route'].";";
            $msg .= "status=".$_GET['status'];

            $initPass = $this->config->get('gateline_initialization_password');
            $signature = hash_hmac('sha1', $msg, $initPass);

            if ($_GET['checksum'] == $signature) {
                $this->model_checkout_order->addOrderHistory($merchant_order_id, $this->config->get('gateline_order_status_id'));
            } else {
                $this->model_checkout_order->addOrderHistory($merchant_order_id, $this->config->get('gateline_order_status_failed_id'));
                $message = "Checksum is incorrect.";
            }
        }

        $data['heading_title'] = $this->language->get('heading_title');
        $data['heading_subtitle'] = $this->language->get('heading_subtitle');
        $data['message'] = $message;

        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer'] = $this->load->controller('common/footer');
        $data['header'] = $this->load->controller('common/header');

        $template = 'default/template/payment/gateline_result.tpl';
        $this->response->setOutput($this->load->view($template, $data));
    }
}
?>